IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'EST_PROD_TRILHO_EXCESSO_PG_FORN') 
BEGIN

	CREATE TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_CTR] [int] NOT NULL,
		[CD_FORN] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TRILHO_EXCESSO_PG_FORN] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_CTR] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_PG_FORN_EST_PROD_TRILHO_EXCESSO] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_CTR])
	REFERENCES [dbo].[EST_PROD_TRILHO_EXCESSO] ([CD_EMP], [CD_FILIAL], [CD_CTR])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_PG_FORN_EST_PROD_TRILHO_EXCESSO]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_PG_FORN_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
	REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] CHECK CONSTRAINT [FK_EST_PROD_TRILHO_EXCESSO_PG_FORN_PG_FORN]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_PG_FORN_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_PG_FORN_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_PG_FORN_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

	ALTER TABLE [dbo].[EST_PROD_TRILHO_EXCESSO_PG_FORN] ADD  CONSTRAINT [DF_EST_PROD_TRILHO_EXCESSO_PG_FORN_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]
END